-- Author  : John D P Purba
-- Purpose : Register Output 32 bit

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY Reg32o IS
	PORT(clock_i	 : IN std_logic;
		 reset_i 	 : IN std_logic;

		 en_i	 : IN std_logic;
		 data_i	 : IN bit32;
		 data_o  : OUT bit32;
		 valid_o : OUT std_logic
	);
END Reg32o;

ARCHITECTURE Reg32o_RTL OF Reg32o IS

SIGNAL sig_data  : bit32;
SIGNAL sig_valid : std_logic;

BEGIN

	data_o <= sig_data;
	valid_o <= sig_valid;		
	
	PROCESS(clock_i,reset_i)
	BEGIN
	IF reset_i = '1' THEN
		sig_data <= (OTHERS => '0');
		sig_valid <= '0';
		
	ELSIF clock_i'EVENT AND clock_i = '1' THEN
		IF en_i = '1' THEN
			sig_data  <= data_i;
			sig_valid <= en_i;		
		ELSE
			sig_data <= (OTHERS => '0');
			sig_valid <= '0';
		END IF;
	END IF;
	END PROCESS;
	
END Reg32o_RTL;









